using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace WindowsGame1
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Sprite tlo;
        Sprite pilka;
        public static int szerokosc = 800;
        public static int wysokosc = 600;
        Texture2D teksturaGracza1;
        Gracz gracz1;
        Gracz gracz2;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.PreferredBackBufferWidth = szerokosc;
            graphics.PreferredBackBufferHeight = wysokosc;
            this.Window.Title = "Pong";
            this.IsMouseVisible = true;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            Services.AddService(typeof(SpriteBatch), spriteBatch);

            tlo = new Sprite(Content.Load<Texture2D>("Pong"), new Vector2(0f, 0f), new Vector2(szerokosc, wysokosc));
            pilka = new Sprite(Content.Load<Texture2D>("Pilka"), new Vector2(szerokosc / 2, wysokosc / 2), new Vector2(szerokosc * 0.04f, szerokosc * 0.04f), new Vector2(3, 3), new Rectangle(0, 0, szerokosc, wysokosc));
            teksturaGracza1 = Content.Load<Texture2D>("Gracz");
            gracz1 = new Gracz(this, teksturaGracza1, new Vector2(0, wysokosc / 2), new Vector2(szerokosc * 0.03f, wysokosc * 0.09f), new Rectangle(0, 0, Convert.ToInt32(szerokosc * 0.03f), wysokosc));
            gracz1.UstawKlawisze(Keys.W, Keys.S);
            gracz2 = new Gracz(this, teksturaGracza1, new Vector2(szerokosc * 0.97f, wysokosc / 2), new Vector2(szerokosc * 0.03f, wysokosc * 0.09f), new Rectangle(0, 0, Convert.ToInt32(szerokosc * 0.03f), wysokosc));
            gracz2.UstawKlawisze(Keys.Up, Keys.Down);
            this.Components.Add(gracz1);
            this.Components.Add(gracz2);
        }


        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            gracz1.ObslugaKolizji(pilka);
            gracz2.ObslugaKolizji(pilka);
            pilka.ZmienPolozenie((float)(gameTime.ElapsedGameTime.TotalMilliseconds / 10)); 

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();
            spriteBatch.Draw(tlo.tekstura, tlo.ObszarOgraniczajacy, Color.White);
            spriteBatch.Draw(pilka.tekstura, pilka.ObszarOgraniczajacy, Color.Red);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
